# Minimal 30px Solitaire (Chrome Extension)

A minimal Klondike Solitaire implementation that lives in a fixed 30px height overlay at the top of your browser.

## Installation

1. Download/Clone this repository.
2. Open Chrome and navigate to `chrome://extensions`.
3. Enable **Developer mode** (top right toggle).
4. Click **Load unpacked**.
5. Select the folder containing these files.
6. The solitaire bar will appear at the top of every page.

## Rules (Klondike Draw 3)

- **Goal**: Move all 52 cards to the 4 Foundation piles on the right, sorted by color (Red, Orange, White, Gray) in ascending order (Ace to King).
- **Tableau (Center 7 piles)**: Build down by alternating "Color Groups".
  - **Group 1**: Red & Orange.
  - **Group 2**: White & Gray.
  - *Example*: You can place a White 5 on a Red 6, or a Gray 5 on an Orange 6.
- **Stock**: Click the left-most pile to draw 3 cards to the Waste. If empty, it recycles the Waste.
- **Waste**: The pile next to Stock. Click the top card to auto-place it (Foundation priority, then Tableau). Or click to select and move manually.

## Controls & UI

- **Auto-Place**: Click a card in Waste or the top of a Tableau pile to automatically move it to the best legal spot.
- **Move**: 
  1. Click a card to select it (highlighted blue).
  2. Click the destination pile to move.
- **Expanded Mode (Horizontal)**:
  - **Double-click** any Tableau pile to view all its face-up cards in a horizontal strip.
  - Click a card in the strip to select a **run** (that card and all above it).
  - The view returns to normal, and you can click a destination Tableau to move the run.
- **Undo**: Infinite undo history.
- **Minimize**: Click the `_` button to collapse the bar to a 2px line. Click the line to restore.

## Constraints & Notes

- **Height**: Strictly 30px.
- **State**: In-memory only. Reloading the page resets the game.
- **Suits**: Mapped to Colors for simplicity:
  - Hearts -> Red
  - Diamonds -> Orange
  - Spades -> White
  - Clubs -> Gray
